/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.annotation.OutputConverter;
import carpet.script.annotation.ScarpetFunction;
import carpet.script.annotation.ValueConverter;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.Value;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public final class AnnotationParser {
    static final int UNDEFINED_PARAMS = -2;
    private static final List<ParsedFunction> functionList = new ArrayList<ParsedFunction>();

    public static void parseFunctionClass(Class<?> clazz) {
        Method[] methodz;
        Supplier instanceSupplier = Suppliers.memoize(() -> {
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new IllegalArgumentException("Function class must be concrete to support non-static methods! Class: " + clazz.getSimpleName());
            }
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Couldn't create instance of given " + clazz + ". This is needed for non-static methods. Make sure default constructor is available", e);
            }
        });
        for (Method method : methodz = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ScarpetFunction.class)) continue;
            if (method.getExceptionTypes().length != 0) {
                throw new IllegalArgumentException("Annotated method '" + method.getName() + "', provided in '" + clazz + "' must not declare checked exceptions");
            }
            ParsedFunction function = new ParsedFunction(method, clazz, (java.util.function.Supplier<Object>)instanceSupplier);
            functionList.add(function);
        }
    }

    public static void apply(Expression expr) {
        for (ParsedFunction function : functionList) {
            expr.addLazyFunction(function.name, function.scarpetParamCount, function);
        }
    }

    private AnnotationParser() {
    }

    private static class ParsedFunction
    implements Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue>,
    Fluff.UsageProvider {
        private final String name;
        private final boolean isMethodVarArgs;
        private final int methodParamCount;
        private final ValueConverter<?>[] valueConverters;
        private final Class<?> varArgsType;
        private final boolean primitiveVarArgs;
        private final ValueConverter<?> varArgsConverter;
        private final OutputConverter<Object> outputConverter;
        private final boolean isEffectivelyVarArgs;
        private final int minParams;
        private final int maxParams;
        private final MethodHandle handle;
        private final int scarpetParamCount;
        private final Context.Type contextType;

        private ParsedFunction(Method method, Class<?> originClass, java.util.function.Supplier<Object> instance) {
            this.name = method.getName();
            this.isMethodVarArgs = method.isVarArgs();
            this.methodParamCount = method.getParameterCount();
            Parameter[] methodParameters = method.getParameters();
            this.valueConverters = new ValueConverter[this.isMethodVarArgs ? this.methodParamCount - 1 : this.methodParamCount];
            for (int i = 0; i < this.methodParamCount; ++i) {
                Parameter param = methodParameters[i];
                if (this.isMethodVarArgs && i == this.methodParamCount - 1) continue;
                this.valueConverters[i] = ValueConverter.fromAnnotatedType(param.getAnnotatedType());
            }
            Class<?> originalVarArgsType = this.isMethodVarArgs ? methodParameters[this.methodParamCount - 1].getType().getComponentType() : null;
            this.varArgsType = ClassUtils.primitiveToWrapper(originalVarArgsType);
            this.primitiveVarArgs = originalVarArgsType != null && originalVarArgsType.isPrimitive();
            this.varArgsConverter = this.isMethodVarArgs ? ValueConverter.fromAnnotatedType(methodParameters[this.methodParamCount - 1].getAnnotatedType()) : null;
            OutputConverter<?> converter = OutputConverter.get(method.getReturnType());
            this.outputConverter = converter;
            this.isEffectivelyVarArgs = this.isMethodVarArgs || Arrays.stream(this.valueConverters).anyMatch(ValueConverter::consumesVariableArgs);
            int maxParams = this.minParams = Arrays.stream(this.valueConverters).mapToInt(ValueConverter::valueConsumption).sum();
            if (this.isEffectivelyVarArgs) {
                maxParams = method.getAnnotation(ScarpetFunction.class).maxParams();
                if (maxParams == -2) {
                    throw new IllegalArgumentException("No maximum number of params specified for " + this.name + ", use ScarpetFunction.UNLIMITED_PARAMS for unlimited. Provided in " + originClass);
                }
                if (maxParams == -1) {
                    maxParams = Integer.MAX_VALUE;
                }
                if (maxParams < this.minParams) {
                    throw new IllegalArgumentException("Provided maximum number of params for " + this.name + " is smaller than method's param count.Provided in " + originClass);
                }
            }
            this.maxParams = maxParams;
            try {
                MethodHandle tempHandle = MethodHandles.publicLookup().unreflect(method).asFixedArity().asSpreader(Object[].class, this.methodParamCount);
                tempHandle = tempHandle.asType(tempHandle.type().changeReturnType(Object.class));
                this.handle = Modifier.isStatic(method.getModifiers()) ? tempHandle : tempHandle.bindTo(instance.get());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.scarpetParamCount = this.isEffectivelyVarArgs ? -1 : this.minParams;
            this.contextType = method.getAnnotation(ScarpetFunction.class).contextType();
        }

        @Override
        public LazyValue apply(Context context, Context.Type t, List<LazyValue> lazyValues) {
            List<Value> lv = Fluff.AbstractLazyFunction.unpackLazy(lazyValues, context, this.contextType);
            if (this.isEffectivelyVarArgs) {
                if (lv.size() < this.minParams) {
                    throw new InternalExpressionException("Function '" + this.name + "' expected at least " + this.minParams + " arguments, got " + lv.size() + ". " + this.getUsage());
                }
                if (lv.size() > this.maxParams) {
                    throw new InternalExpressionException("Function '" + this.name + " expected up to " + this.maxParams + " arguments, got " + lv.size() + ". " + this.getUsage());
                }
            }
            Object[] params = this.getMethodParams(lv, context, t);
            try {
                return this.outputConverter.convert(this.handle.invokeExact(params));
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Error)e;
            }
        }

        private Object[] getMethodParams(List<Value> lv, Context context, Context.Type theLazyT) {
            Object[] params = new Object[this.methodParamCount];
            ListIterator<Value> lvIterator = lv.listIterator();
            int regularArgs = this.isMethodVarArgs ? this.methodParamCount - 1 : this.methodParamCount;
            for (int i = 0; i < regularArgs; ++i) {
                params[i] = this.valueConverters[i].checkAndConvert(lvIterator, context, theLazyT);
                if (params[i] != null) continue;
                throw new InternalExpressionException("Incorrect argument passsed to '" + this.name + "' function.\n" + this.getUsage());
            }
            if (this.isMethodVarArgs) {
                Object[] varArgs;
                int remaining = lv.size() - lvIterator.nextIndex();
                if (this.varArgsConverter.consumesVariableArgs()) {
                    ArrayList varArgsList = new ArrayList();
                    while (lvIterator.hasNext()) {
                        Object obj = this.varArgsConverter.checkAndConvert(lvIterator, context, theLazyT);
                        if (obj == null) {
                            throw new InternalExpressionException("Incorrect argument passsed to '" + this.name + "' function.\n" + this.getUsage());
                        }
                        varArgsList.add(obj);
                    }
                    varArgs = varArgsList.toArray((Object[])Array.newInstance(this.varArgsType, 0));
                } else {
                    varArgs = (Object[])Array.newInstance(this.varArgsType, remaining / this.varArgsConverter.valueConsumption());
                    int i = 0;
                    while (lvIterator.hasNext()) {
                        varArgs[i] = this.varArgsConverter.checkAndConvert(lvIterator, context, theLazyT);
                        if (varArgs[i] == null) {
                            throw new InternalExpressionException("Incorrect argument passsed to '" + this.name + "' function.\n" + this.getUsage());
                        }
                        ++i;
                    }
                }
                params[this.methodParamCount - 1] = this.primitiveVarArgs ? ArrayUtils.toPrimitive((Object)varArgs) : varArgs;
            }
            return params;
        }

        @Override
        public String getUsage() {
            StringBuilder builder = new StringBuilder("Usage: '");
            builder.append(this.name);
            builder.append('(');
            builder.append(Arrays.stream(this.valueConverters).map(ValueConverter::getTypeName).filter(Objects::nonNull).collect(Collectors.joining(", ")));
            if (this.varArgsConverter != null) {
                builder.append(", ");
                builder.append(this.varArgsConverter.getTypeName());
                builder.append("s...)");
            } else {
                builder.append(')');
            }
            builder.append("'");
            return builder.toString();
        }
    }
}

