/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.compat;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import me.modmuss50.optifabric.compat.InterceptingMixinPlugin;
import me.modmuss50.optifabric.util.MixinUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Annotations;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.PARAMETER})
public @interface LoudCoerce {
    public String value();

    public boolean remap() default true;

    public static class CoercionApplicator {
        public static void preApply(IMixinInfo mixinInfo, ClassNode targetClass) {
            MixinUtils.Mixin thisMixin = MixinUtils.Mixin.create(mixinInfo);
            block0: for (MethodNode method : thisMixin.getClassNode().methods) {
                String coercedDesc;
                if (Annotations.getVisible((MethodNode)method, Surrogate.class) == null || (coercedDesc = InterceptingMixinPlugin.coerceDesc(method)) == null) continue;
                for (ClassInfo.Method realMethod : thisMixin.getMethods()) {
                    if (!realMethod.getOriginalName().equals(method.name) || method.desc.equals(realMethod.getOriginalDesc())) continue;
                    Annotations.setInvisible((MethodNode)method, CoercedInPlace.class, (Object[])new Object[0]);
                    method.name = realMethod.getName();
                    method.desc = coercedDesc;
                    targetClass.methods.add(method);
                    continue block0;
                }
                throw new IllegalStateException("Cannot find original Mixin method for surrogate " + method.name + method.desc + " in " + thisMixin);
            }
        }

        public static void postApply(ClassNode targetClass) {
            Iterator it = targetClass.methods.iterator();
            while (it.hasNext()) {
                String coercedDesc;
                MethodNode method = (MethodNode)it.next();
                if (Annotations.getInvisible((MethodNode)method, CoercedInPlace.class) != null) {
                    it.remove();
                    continue;
                }
                if (Annotations.getVisible((MethodNode)method, Surrogate.class) == null || (coercedDesc = InterceptingMixinPlugin.coerceDesc(method)) == null) continue;
                method.desc = coercedDesc;
            }
        }

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.CLASS)
        private static @interface CoercedInPlace {
        }
    }
}

