/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import me.modmuss50.optifabric.mod.OptifabricError;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.LambdaRebuilder;
import me.modmuss50.optifabric.util.ASMUtils;
import me.modmuss50.optifabric.util.ZipUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class OptifineSetup {
    public static Pair<File, ClassCache> getRuntime() throws IOException {
        Consumer<ZipUtils.ZipVisitor> jarFinaliser;
        byte[] modHash;
        File workingDir = new File(FabricLoader.getInstance().getGameDirectory(), ".optifine");
        if (!workingDir.exists()) {
            FileUtils.forceMkdir((File)workingDir);
        }
        File optifineModJar = OptifineVersion.findOptifineJar();
        try (FileInputStream in = new FileInputStream(optifineModJar);){
            modHash = DigestUtils.md5((InputStream)in);
        }
        File versionDir = new File(workingDir, OptifineVersion.version);
        if (!versionDir.exists()) {
            FileUtils.forceMkdir((File)versionDir);
        }
        Object remappedJar = new File(versionDir, "Optifine-mapped.jar");
        File optifinePatches = new File(versionDir, "Optifine.classes.gz");
        if (remappedJar.exists() && optifinePatches.exists()) {
            ClassCache classCache = ClassCache.read(optifinePatches);
            if (Arrays.equals(classCache.getHash(), modHash)) {
                System.out.println("Found existing patched optifine jar, using that");
                if (classCache.isConverted()) {
                    classCache.save(optifinePatches);
                }
                return Pair.of((Object)remappedJar, (Object)classCache);
            }
            System.out.println("Class cache is from a different optifine jar, deleting and re-generating");
        } else {
            System.out.println("Setting up optifine for the first time, this may take a few seconds.");
        }
        Path minecraftJar = OptifineSetup.getMinecraftJar();
        File workDir = Files.createTempDirectory("optifabric", new FileAttribute[0]).toFile();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            File optifineMod;
            block30: {
                optifineMod = new File(workDir, "Optifine-mod.jar");
                if (!optifineMod.exists() || !ZipUtils.isValid(optifineMod)) {
                    for (int attempt = 1; attempt <= 3; ++attempt) {
                        OptifineSetup.runInstaller(optifineModJar, optifineMod, minecraftJar.toFile());
                        if (!ZipUtils.isValid(optifineMod)) {
                            optifineMod.delete();
                            continue;
                        }
                        break block30;
                    }
                    OptifineVersion.jarType = OptifineVersion.JarType.CORRUPT_ZIP;
                    OptifabricError.setError("OptiFine installer keeps producing corrupt jars!\nRan: %s 3 times\nMinecraft jar: %s", optifineModJar, minecraftJar);
                    throw new ZipException("Ran OptiFine installer (" + optifineModJar + ") three times without a valid jar produced");
                }
            }
            optifineModJar = optifineMod;
        }
        File jarOfTheFree = new File(workDir, "Optifine-jarofthefree.jar");
        final LambdaRebuilder rebuilder = new LambdaRebuilder(minecraftJar.toFile());
        System.out.println("De-Volderfiying jar");
        ZipUtils.transform(optifineModJar, new ZipUtils.ZipTransformer(){

            @Override
            public String mapName(ZipEntry entry) {
                String out = entry.getName();
                return out.startsWith("notch/") ? out.substring(6) : out;
            }

            @Override
            public InputStream apply(ZipFile zip, ZipEntry entry) throws IOException {
                String name = entry.getName();
                if (!name.startsWith("srg/")) {
                    if (!(!name.endsWith(".class") || name.startsWith("net/") || name.startsWith("notch/net/") || name.startsWith("optifine/") || name.startsWith("javax/"))) {
                        ClassNode node = ASMUtils.readClass(zip, entry);
                        rebuilder.findLambdas(node);
                        ClassWriter writer = new ClassWriter(0);
                        node.accept((ClassVisitor)writer);
                        return new ByteArrayInputStream(writer.toByteArray());
                    }
                    return zip.getInputStream(entry);
                }
                return null;
            }
        }, jarOfTheFree);
        rebuilder.close();
        String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
        System.out.println("Remapping optifine from official to " + namespace);
        File completeJar = new File(workDir, "Optifine-remapped.jar");
        OptifineSetup.remapOptifine(jarOfTheFree, OptifineSetup.getLibs(minecraftJar), completeJar, OptifineSetup.createMappings("official", namespace, rebuilder));
        for (UnaryOperator transformer : FabricLoader.getInstance().getEntrypoints("optifabric:transformer", UnaryOperator.class)) {
            completeJar = (File)transformer.apply(completeJar);
            if (completeJar != null && completeJar.canRead()) continue;
            throw new IllegalStateException("Jar transformer returned invalid jar: " + completeJar);
        }
        File completedJar = completeJar;
        if (remappedJar.exists() && !remappedJar.delete()) {
            System.err.println("Failed to clear " + remappedJar + ", is another instance of the game running?");
            remappedJar = completedJar;
            jarFinaliser = visitor -> ZipUtils.filterInPlace(completedJar, visitor);
        } else {
            File[] finalRemappedJar = remappedJar;
            jarFinaliser = arg_0 -> OptifineSetup.lambda$getRuntime$1(completedJar, (File)finalRemappedJar, arg_0);
        }
        if (optifinePatches.exists() && !optifinePatches.delete()) {
            System.err.println("Failed to clear " + optifinePatches + ", is another instance of the game running?");
            optifinePatches = new File(workDir, "Optifine.classes.gz");
        }
        workDir.deleteOnExit();
        for (File file : workDir.listFiles()) {
            file.deleteOnExit();
        }
        boolean extract = Boolean.getBoolean("optifabric.extract");
        if (extract) {
            System.out.println("Extracting optifine classes");
            File optifineClasses = new File(versionDir, "optifine-classes");
            if (optifineClasses.exists()) {
                FileUtils.deleteDirectory((File)optifineClasses);
            }
            ZipUtils.extract(completedJar, optifineClasses);
        }
        return Pair.of((Object)remappedJar, (Object)OptifineSetup.generateClassCache(jarFinaliser, optifinePatches, modHash, extract));
    }

    private static void runInstaller(File installer, File output, File minecraftJar) throws IOException {
        System.out.println("Running optifine patcher");
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{installer.toURI().toURL()}, OptifineSetup.class.getClassLoader());){
            Class<?> clazz = classLoader.loadClass("optifine.Patcher");
            Method method = clazz.getDeclaredMethod("process", File.class, File.class, File.class);
            method.invoke(null, minecraftJar, installer, output);
        }
        catch (ReflectiveOperationException | MalformedURLException e) {
            throw new RuntimeException("Error running OptiFine patcher at " + installer + " on " + minecraftJar, e);
        }
    }

    private static void remapOptifine(File input, Path[] libraries, File output, IMappingProvider mappings) throws IOException {
        OptifineSetup.remapOptifine(input.toPath(), libraries, output.toPath(), mappings);
    }

    private static void remapOptifine(Path input, Path[] libraries, Path output, IMappingProvider mappings) throws IOException {
        Files.deleteIfExists(output);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).skipLocalVariableMapping(true).renameInvalidLocals(FabricLoader.getInstance().isDevelopmentEnvironment()).rebuildSourceFilenames(true).build();
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(output).assumeArchive(true).build();){
            outputConsumer.addNonClassFiles(input);
            remapper.readInputs(new Path[]{input});
            remapper.readClassPath(libraries);
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap jar", e);
        }
        finally {
            remapper.finish();
        }
    }

    private static IMappingProvider createMappings(String from, String to, IMappingProvider extra) {
        TinyTree normalMappings = FabricLauncherBase.getLauncher().getMappingConfiguration().getMappings();
        Map nameToClass = normalMappings.getClasses().stream().collect(Collectors.toMap(clazz -> clazz.getName("intermediary"), Function.identity()));
        HashMap<IMappingProvider.Member, String> extraMethods = new HashMap<IMappingProvider.Member, String>();
        HashMap<IMappingProvider.Member, String> extraFields = new HashMap<IMappingProvider.Member, String>();
        ClassDef rebuildTask = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851$class_4578");
        ClassDef builtChunk = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851");
        extraFields.put(new IMappingProvider.Member(rebuildTask.getName(from), "this$1", 'L' + builtChunk.getName(from) + ';'), "field_20839");
        ClassDef particleManager = (ClassDef)nameToClass.get("net/minecraft/class_702");
        particleManager.getFields().stream().filter(field -> "field_3835".equals(field.getName("intermediary"))).forEach(field -> extraFields.put(new IMappingProvider.Member(particleManager.getName(from), field.getName(from), "Ljava/util/Map;"), field.getName(to)));
        ClassDef clientEntityHandler = (ClassDef)nameToClass.get("net/minecraft/class_638$class_5612");
        if (clientEntityHandler != null) {
            ClassDef clientWorld = (ClassDef)nameToClass.get("net/minecraft/class_638");
            extraFields.put(new IMappingProvider.Member(clientEntityHandler.getName(from), "this$0", 'L' + clientWorld.getName(from) + ';'), "field_27735");
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ClassDef option = (ClassDef)nameToClass.get("net/minecraft/class_316");
            ClassDef cyclingOption = (ClassDef)nameToClass.get("net/minecraft/class_4064");
            extraFields.put(new IMappingProvider.Member(option.getName(from), "CLOUDS", 'L' + cyclingOption.getName(from) + ';'), "CLOUDS_OF");
            ClassDef worldRenderer = (ClassDef)nameToClass.get("net/minecraft/class_761");
            extraFields.put(new IMappingProvider.Member(worldRenderer.getName(from), "renderDistance", "I"), "renderDistance_OF");
            ClassDef threadExecutor = (ClassDef)nameToClass.get("net/minecraft/class_1255");
            extraMethods.put(new IMappingProvider.Member(threadExecutor.getName(from), "getTaskCount", "()I"), "getTaskCount_OF");
            ClassDef vertexBuffer = (ClassDef)nameToClass.get("net/minecraft/class_291");
            extraFields.put(new IMappingProvider.Member(vertexBuffer.getName(from), "vertexCount", "I"), "vertexCount_OF");
            String modelPart = ((ClassDef)nameToClass.get("net/minecraft/class_630")).getName(from);
            extraMethods.put(new IMappingProvider.Member(modelPart, "getChild", "(Ljava/lang/String;)L" + modelPart + ';'), "getChild_OF");
        }
        return out -> {
            for (ClassDef classDef : normalMappings.getClasses()) {
                String className = classDef.getName(from);
                out.acceptClass(className, classDef.getName(to));
                for (FieldDef field : classDef.getFields()) {
                    out.acceptField(new IMappingProvider.Member(className, field.getName(from), field.getDescriptor(from)), field.getName(to));
                }
                for (MethodDef method : classDef.getMethods()) {
                    out.acceptMethod(new IMappingProvider.Member(className, method.getName(from), method.getDescriptor(from)), method.getName(to));
                }
            }
            extraMethods.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptMethod(arg_0, arg_1));
            extraFields.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptField(arg_0, arg_1));
            extra.load(out);
        };
    }

    private static Path[] getLibs(Path minecraftJar) {
        Object[] libs;
        block2: {
            libs = (Path[])FabricLauncherBase.getLauncher().getLoadTimeDependencies().stream().map(url -> {
                try {
                    return Paths.get(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Failed to convert " + url + " to path", e);
                }
            }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                Path launchJar = OptifineSetup.getLaunchMinecraftJar();
                int end = libs.length;
                for (int i = 0; i < end; ++i) {
                    Path lib = libs[i];
                    if (!launchJar.equals(lib)) continue;
                    libs[i] = minecraftJar;
                    break block2;
                }
                throw new IllegalStateException("Unable to find Minecraft jar (at " + launchJar + ") in classpath: " + Arrays.toString(libs));
            }
        }
        return libs;
    }

    private static Path getMinecraftJar() {
        String givenJar = System.getProperty("optifabric.mc-jar");
        if (givenJar != null) {
            File givenJarFile = new File(givenJar);
            if (givenJarFile.exists()) {
                return givenJarFile.toPath();
            }
            System.err.println("Supplied Minecraft jar at " + givenJar + " doesn't exist, falling back");
        }
        Path minecraftJar = OptifineSetup.getLaunchMinecraftJar();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path officialNames = minecraftJar.resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (Files.notExists(officialNames, new LinkOption[0])) {
                Path parent = minecraftJar.getParent().resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
                if (Files.notExists(parent, new LinkOption[0])) {
                    Path alternativeParent = parent.resolveSibling("minecraft-client.jar");
                    if (Files.notExists(alternativeParent, new LinkOption[0])) {
                        throw new AssertionError((Object)("Unable to find Minecraft dev jar! Tried " + officialNames + ", " + parent + " and " + alternativeParent + "\nPlease supply it explicitly with -Doptifabric.mc-jar"));
                    }
                    parent = alternativeParent;
                }
                officialNames = parent;
            }
            minecraftJar = officialNames;
        }
        return minecraftJar;
    }

    private static Path getLaunchMinecraftJar() {
        try {
            return (Path)FabricLoader.getInstance().getObjectShare().get("fabric-loader:inputGameJar");
        }
        catch (NoClassDefFoundError | NoSuchMethodError old) {
            Path out;
            int split;
            ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new IllegalStateException("No Minecraft?"));
            URI uri = mod.getRootPath().toUri();
            assert ("jar".equals(uri.getScheme()));
            String path = uri.getSchemeSpecificPart();
            if (path.substring(0, split = path.lastIndexOf("!/")).indexOf(32) > 0 && path.startsWith("file:///") && Files.exists(out = Paths.get(path.substring(8, split), new String[0]), new LinkOption[0])) {
                return out;
            }
            try {
                return Paths.get(new URI(path.substring(0, split)));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to find Minecraft jar from " + uri + " (calculated " + path.substring(0, split) + ')', e);
            }
        }
    }

    private static ClassCache generateClassCache(Consumer<ZipUtils.ZipVisitor> from, File to, byte[] hash, boolean extractClasses) throws IOException {
        File classesDir = new File(to.getParent(), "classes");
        if (extractClasses) {
            if (classesDir.exists()) {
                FileUtils.cleanDirectory((File)classesDir);
            } else {
                FileUtils.forceMkdir((File)classesDir);
            }
        }
        ClassCache classCache = new ClassCache(hash);
        from.accept((jarFile, entry) -> {
            String name = entry.getName();
            if ((name.startsWith("net/minecraft/") || name.startsWith("com/mojang/")) && name.endsWith(".class")) {
                try (InputStream in = jarFile.getInputStream(entry);){
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    classCache.addClass(name.substring(0, name.length() - 6), bytes);
                    if (extractClasses) {
                        FileUtils.writeByteArrayToFile((File)new File(classesDir, name), (byte[])bytes);
                    }
                }
                return false;
            }
            return true;
        });
        System.out.println("Found " + classCache.getClasses().size() + " patched classes");
        classCache.save(to);
        return classCache;
    }

    private static /* synthetic */ void lambda$getRuntime$1(File completedJar, File finalRemappedJar, ZipUtils.ZipVisitor visitor) {
        ZipUtils.filter(completedJar, visitor, finalRemappedJar);
    }
}

