/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.Log;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<bau, fcm> originalEntityRenderMap = null;
    private static Map<csn, ezr> originalTileEntityRenderMap = null;
    private static Map<cpp.a, erv> originalSkullModelMap = null;
    private static List<csn> customTileEntityTypes = new ArrayList();
    private static epn customBookModel;
    private static boolean debugModels;

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        exg blockEntityRenderer = eev.G().ag().getBlockEntityRenderer();
        blockEntityRenderer.j = new esc(ModelAdapter.bakeModelLayer((est)esu.bx));
        fgr.customParrotModel = null;
        customBookModel = null;
        ezr.CACHED_TYPES.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        aaj[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            aaj loc = locs[i2];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((aaj)loc);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof fcm) {
                fdz pr2;
                era pm2;
                fey tr;
                esc tm;
                entityRenderMap.put((bau)type.getLeft().get(), (fcm)rc);
                if (rc instanceof fey && (tm = (esc)Reflector.getFieldValue((Object)(tr = (fey)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.j = tm;
                }
                if (rc instanceof fdz && (pm2 = (era)(pr2 = (fdz)rc).a()) != null) {
                    fgr.customParrotModel = pm2;
                }
            } else if (rc instanceof ezr) {
                tileEntityRenderMap.put((csn)type.getRight().get(), (ezr)rc);
                if (rc instanceof ezy) {
                    ezy etr = (ezy)rc;
                    epn bm = (epn)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((epn)bm);
                }
                customTileEntityTypes.add((csn)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
            }
            active = true;
        }
    }

    private static void setEnchantmentScreenBookModel(epn bookModel) {
        customBookModel = bookModel;
    }

    private static Map<bau, fcm> getEntityRenderMap() {
        fcl rm2 = eev.G().ae();
        Map entityRenderMap = rm2.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<csn, ezr> getTileEntityRenderMap() {
        ezq blockEntityRenderDispatcher = eev.G().af();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<cpp.a, erv> getSkullModelMap() {
        HashMap skullModelMap = fad.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static aaj[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<aaj> resourceLocations = new ArrayList<aaj>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            aaj loc = new aaj(path);
            if (!Config.hasResource((aaj)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        aaj[] locs = resourceLocations.toArray(new aaj[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(aaj location) {
        try {
            if (debugModels) {
                return CustomEntityModels.makeDebugEntityRenderer((aaj)location);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((aaj)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(aaj loc) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        eqw model = ma.makeModel();
        byt[] colors = byt.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i2 = 0; i2 < partNames.length; ++i2) {
            String partName = partNames[i2];
            esv part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            byt col = colors[(i2 + offset) % colors.length];
            aaj locTexture = new aaj("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize());
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        eqw model;
        aaj textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (eqw)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (eqw)model, (IEntityRenderer)r, (aaj)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, eqw model, IEntityRenderer er, aaj textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof fdo) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (eqw)model, (aaj)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, eqw model, aaj textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            esv modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, eqw model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (eqw)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, eqw model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        esv parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                esv[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    esv mr = (esv)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(cur blockStateIn) {
        for (int i2 = 0; i2 < customTileEntityTypes.size(); ++i2) {
            csn type = (csn)customTileEntityTypes.get(i2);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(ekj screen) {
        if (customBookModel != null && screen instanceof ely) {
            ely es = (ely)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    static {
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

