/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.util.ArrayList;
import net.optifine.Lang;
import net.optifine.shaders.ShaderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderProfile;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShaderOptionProfile
extends ShaderOption {
    private ShaderProfile[] profiles = null;
    private ShaderOption[] options = null;
    private static final String NAME_PROFILE = "<profile>";
    private static final String VALUE_CUSTOM = "<custom>";

    public ShaderOptionProfile(ShaderProfile[] profiles, ShaderOption[] options) {
        super("<profile>", "", ShaderOptionProfile.detectProfileName((ShaderProfile[])profiles, (ShaderOption[])options), ShaderOptionProfile.getProfileNames((ShaderProfile[])profiles), ShaderOptionProfile.detectProfileName((ShaderProfile[])profiles, (ShaderOption[])options, (boolean)true), null);
        this.profiles = profiles;
        this.options = options;
    }

    public void nextValue() {
        super.nextValue();
        if (this.getValue().equals("<custom>")) {
            super.nextValue();
        }
        this.applyProfileOptions();
    }

    public void updateProfile() {
        ShaderProfile prof = this.getProfile(this.getValue());
        if (prof != null && ShaderUtils.matchProfile((ShaderProfile)prof, (ShaderOption[])this.options, (boolean)false)) {
            return;
        }
        String val = ShaderOptionProfile.detectProfileName((ShaderProfile[])this.profiles, (ShaderOption[])this.options);
        this.setValue(val);
    }

    private void applyProfileOptions() {
        ShaderProfile prof = this.getProfile(this.getValue());
        if (prof == null) {
            return;
        }
        String[] opts = prof.getOptions();
        for (int i2 = 0; i2 < opts.length; ++i2) {
            String name = opts[i2];
            ShaderOption so2 = this.getOption(name);
            if (so2 == null) continue;
            String val = prof.getValue(name);
            so2.setValue(val);
        }
    }

    private ShaderOption getOption(String name) {
        for (int i2 = 0; i2 < this.options.length; ++i2) {
            ShaderOption so2 = this.options[i2];
            if (!so2.getName().equals(name)) continue;
            return so2;
        }
        return null;
    }

    private ShaderProfile getProfile(String name) {
        for (int i2 = 0; i2 < this.profiles.length; ++i2) {
            ShaderProfile prof = this.profiles[i2];
            if (!prof.getName().equals(name)) continue;
            return prof;
        }
        return null;
    }

    public String getNameText() {
        return Lang.get((String)"of.shaders.profile");
    }

    public String getValueText(String val) {
        if (val.equals("<custom>")) {
            return Lang.get((String)"of.general.custom", (String)"<custom>");
        }
        return Shaders.translate((String)("profile." + val), (String)val);
    }

    public String getValueColor(String val) {
        if (val.equals("<custom>")) {
            return "\u00a7c";
        }
        return "\u00a7a";
    }

    public String getDescriptionText() {
        String text = Shaders.translate((String)"profile.comment", null);
        if (text != null) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.profiles.length; ++i2) {
            String profText;
            String name = this.profiles[i2].getName();
            if (name == null || (profText = Shaders.translate((String)("profile." + name + ".comment"), null)) == null) continue;
            sb.append(profText);
            if (profText.endsWith(". ")) continue;
            sb.append(". ");
        }
        return sb.toString();
    }

    private static String detectProfileName(ShaderProfile[] profs, ShaderOption[] opts) {
        return ShaderOptionProfile.detectProfileName((ShaderProfile[])profs, (ShaderOption[])opts, (boolean)false);
    }

    private static String detectProfileName(ShaderProfile[] profs, ShaderOption[] opts, boolean def) {
        ShaderProfile prof = ShaderUtils.detectProfile((ShaderProfile[])profs, (ShaderOption[])opts, (boolean)def);
        if (prof == null) {
            return "<custom>";
        }
        return prof.getName();
    }

    private static String[] getProfileNames(ShaderProfile[] profs) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < profs.length; ++i2) {
            ShaderProfile prof = profs[i2];
            list.add(prof.getName());
        }
        list.add("<custom>");
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }
}

