/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.fabric.ShulkerBoxTooltipImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.EnderChestPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.PreviewProviderRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShulkerBoxTooltip
implements ShulkerBoxTooltipApi {
    public static final String MOD_ID = "shulkerboxtooltip";
    public static final String MOD_NAME = "ShulkerBoxTooltip";
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ShulkerBoxTooltip");
    public static Configuration config;
    public static Configuration savedConfig;
    private static boolean registeredProviders;
    public static final class_1792[] SHULKER_BOX_ITEMS;

    public static void init() {
        savedConfig = ConfigurationHandler.register();
        config = ConfigurationHandler.copyOf(savedConfig);
        ServerNetworking.init();
    }

    private static void register(PreviewProviderRegistry registry, String id, PreviewProvider provider, class_1792 ... items) {
        registry.register(ShulkerBoxTooltipUtil.id(id), provider, items);
    }

    @Override
    public void registerProviders(PreviewProviderRegistry registry) {
        ShulkerBoxTooltip.register(registry, "shulker_box", new ShulkerBoxPreviewProvider(), SHULKER_BOX_ITEMS);
        ShulkerBoxTooltip.register(registry, "chest_like", new BlockEntityPreviewProvider(27, true), class_1802.field_8106, class_1802.field_8247, class_1802.field_16307);
        ShulkerBoxTooltip.register(registry, "furnace_like", new BlockEntityPreviewProvider(3, false, 1), class_1802.field_8732, class_1802.field_16306, class_1802.field_16309);
        ShulkerBoxTooltip.register(registry, "dropper_like", new BlockEntityPreviewProvider(9, true, 3), class_1802.field_8878, class_1802.field_8357);
        ShulkerBoxTooltip.register(registry, "hopper", new BlockEntityPreviewProvider(5, true, 5), class_1802.field_8239);
        ShulkerBoxTooltip.register(registry, "brewing_stand", new BlockEntityPreviewProvider(5, false, 3), class_1802.field_8740);
        ShulkerBoxTooltip.register(registry, "ender_chest", new EnderChestPreviewProvider(), class_1802.field_8466);
    }

    public static void initPreviewItemsMap() {
        if (registeredProviders) {
            return;
        }
        registeredProviders = true;
        List<PluginContainer> plugins = ShulkerBoxTooltip.getPluginContainers();
        String pluginText = switch (plugins.size()) {
            case 0 -> "Loading %d plugins";
            case 1 -> "Loading %d plugin: %s";
            default -> "Loading %d plugins: %s";
        };
        LOGGER.info("[ShulkerBoxTooltip] " + pluginText, (Object)plugins.size(), (Object)plugins.stream().map(PluginContainer::modId).collect(Collectors.joining(", ")));
        for (PluginContainer plugin : plugins) {
            PreviewProviderRegistryImpl registry = PreviewProviderRegistryImpl.INSTANCE;
            int prevSize = registry.getIds().size();
            registry.setLocked(false);
            plugin.apiImplSupplier.get().registerProviders(registry);
            registry.setLocked(true);
            int registered = registry.getIds().size() - prevSize;
            String providerText = registered == 1 ? "Registered %d provider for mod %s" : "Registered %d providers for mod %s";
            LOGGER.info("[ShulkerBoxTooltip] " + providerText, (Object)registered, (Object)plugin.modId());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return ShulkerBoxTooltipImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return ShulkerBoxTooltipImpl.getConfigDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<PluginContainer> getPluginContainers() {
        return ShulkerBoxTooltipImpl.getPluginContainers();
    }

    static {
        registeredProviders = false;
        SHULKER_BOX_ITEMS = new class_1792[]{class_1802.field_8545, class_1802.field_8722, class_1802.field_8380, class_1802.field_8050, class_1802.field_8829, class_1802.field_8271, class_1802.field_8548, class_1802.field_8520, class_1802.field_8627, class_1802.field_8451, class_1802.field_8213, class_1802.field_8816, class_1802.field_8350, class_1802.field_8584, class_1802.field_8461, class_1802.field_8676, class_1802.field_8268};
    }

    public record PluginContainer(String modId, Supplier<ShulkerBoxTooltipApi> apiImplSupplier) {
    }
}

