/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ShulkerBoxTooltipClient {
    private static class_1799 previousStack = null;
    public static class_310 client;
    private static boolean wasPreviewAccessed;
    private static boolean previewKeyPressed;
    private static boolean fullPreviewKeyPressed;

    public static void init() {
        client = class_310.method_1551();
        ClientNetworking.init();
    }

    public static boolean shouldDisplayPreview() {
        return ShulkerBoxTooltip.config.preview.alwaysOn || ShulkerBoxTooltipApi.isPreviewKeyPressed();
    }

    @Nullable
    public static class_2561 getTooltipHint(PreviewContext context, PreviewProvider provider) {
        boolean shouldDisplay = ShulkerBoxTooltipClient.shouldDisplayPreview();
        if (!ShulkerBoxTooltip.config.preview.enable || !provider.shouldDisplay(context) || shouldDisplay && ShulkerBoxTooltipApi.isFullPreviewKeyPressed()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(context);
        if (!fullPreviewAvailable && shouldDisplay) {
            return null;
        }
        class_5250 keyHint = class_2561.method_43470((String)"");
        class_2561 previewKeyText = ShulkerBoxTooltip.config.controls.previewKey.get().method_27445();
        if (shouldDisplay) {
            keyHint.method_10852(ShulkerBoxTooltip.config.controls.fullPreviewKey.get().method_27445());
            if (!ShulkerBoxTooltip.config.preview.alwaysOn) {
                keyHint.method_27693("+").method_10852(previewKeyText);
            }
        } else {
            keyHint.method_10852(previewKeyText);
        }
        keyHint.method_27693(": ");
        keyHint.method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
        String contentHint = ShulkerBoxTooltipApi.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltip.config.preview.swapModes ? provider.getFullTooltipHintLangKey(context) : provider.getTooltipHintLangKey(context)) : (ShulkerBoxTooltip.config.preview.swapModes ? provider.getTooltipHintLangKey(context) : provider.getFullTooltipHintLangKey(context));
        return keyHint.method_10852((class_2561)class_2561.method_43471((String)contentHint).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
    }

    public static void modifyStackTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (client == null) {
            return;
        }
        PreviewContext context = PreviewContext.of(stack, (class_1657)ShulkerBoxTooltipClient.client.field_1724);
        PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(stack);
        if (provider == null) {
            return;
        }
        if (previousStack == null || !class_1799.method_7973((class_1799)stack, (class_1799)previousStack)) {
            wasPreviewAccessed = false;
        }
        previousStack = stack;
        if (!wasPreviewAccessed) {
            provider.onInventoryAccessStart(context);
        }
        wasPreviewAccessed = true;
        if (provider.showTooltipHints(context)) {
            class_2561 hint;
            if (ShulkerBoxTooltip.config.tooltip.type == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.addAll(provider.addTooltip(context));
            }
            if (ShulkerBoxTooltip.config.tooltip.showKeyHints && (hint = ShulkerBoxTooltipClient.getTooltipHint(context, provider)) != null) {
                tooltip.add(hint);
            }
        }
    }

    public static boolean isPreviewKeyPressed() {
        return previewKeyPressed;
    }

    public static boolean isFullPreviewKeyPressed() {
        return fullPreviewKeyPressed;
    }

    private static boolean isKeyPressed(@Nullable Key key) {
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)class_3675.field_16237)) {
            return false;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.get().method_1444());
    }

    public static void updatePreviewKeys() {
        Configuration config = ShulkerBoxTooltip.config;
        if (config == null) {
            previewKeyPressed = false;
            fullPreviewKeyPressed = false;
        } else {
            previewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.previewKey);
            fullPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.fullPreviewKey);
        }
    }

    static {
        wasPreviewAccessed = false;
        previewKeyPressed = false;
        fullPreviewKeyPressed = false;
    }
}

