/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ShulkerBoxTooltipConfigSerializer;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.AutoTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.Validator;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3675;

public final class ConfigurationHandler {
    public static Configuration copyOf(Configuration source) {
        Configuration c = new Configuration();
        c.preview = Configuration.PreviewCategory.copyFrom(source.preview);
        c.tooltip = Configuration.TooltipCategory.copyFrom(source.tooltip);
        c.server = Configuration.ServerCategory.copyFrom(source.server);
        if (ShulkerBoxTooltip.isClient()) {
            c.controls = Configuration.ControlsCategory.copyFrom(source.controls);
        }
        return c;
    }

    public static Configuration register() {
        Configuration configuration = (Configuration)AutoConfig.register(Configuration.class, ShulkerBoxTooltipConfigSerializer::new).getConfig();
        AutoConfig.getConfigHolder(Configuration.class).registerSaveListener((holder, config) -> {
            ConfigurationHandler.onSave();
            return class_1269.field_5811;
        });
        if (ShulkerBoxTooltip.isClient()) {
            ConfigurationHandler.registerGui();
        }
        return configuration;
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerGui() {
        GuiRegistry registry = AutoConfig.getGuiRegistry(Configuration.class);
        registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (gui instanceof TooltipListEntry) {
                TooltipListEntry entry = (TooltipListEntry)gui;
                entry.setTooltipSupplier(() -> ConfigurationHandler.splitTooltipKey(i13n + ".tooltip"));
            }
        }).collect(Collectors.toList()), new Class[]{AutoTooltip.class});
        registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            Function<Object, Optional<class_2561>> validator = ConfigurationHandler.getValidatorFunction(field.getAnnotation(Validator.class));
            gui.setErrorSupplier(() -> (Optional)validator.apply(gui.getValue()));
        }).collect(Collectors.toList()), new Class[]{Validator.class});
        registry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeEntry entry = ConfigEntryBuilder.create().startKeyCodeField((class_2561)class_2561.method_43471((String)i13n), ((Key)Utils.getUnsafely((Field)field, (Object)config, (Object)new Key(class_3675.field_16237))).get()).setDefaultValue(() -> ((Key)Utils.getUnsafely((Field)field, (Object)defaults)).get()).setSaveConsumer(newValue -> ((Key)Utils.getUnsafely((Field)field, (Object)config, (Object)new Key(class_3675.field_16237))).set((class_3675.class_306)newValue)).build();
            entry.setAllowMouse(false);
            return Collections.singletonList(entry);
        }, field -> field.getType() == Key.class);
    }

    private static Optional<class_2561[]> splitTooltipKey(String key) {
        String[] lines = class_2477.method_10517().method_4679(key).split("\n");
        class_2561[] tooltip = new class_2561[lines.length];
        int l = lines.length;
        for (int i = 0; i < l; ++i) {
            tooltip[i] = class_2561.method_43470((String)lines[i]);
        }
        return Optional.of(tooltip);
    }

    public static void validate(Configuration config) throws ConfigData.ValidationException {
        ConfigurationHandler.runValidators(Configuration.PreviewCategory.class, config.preview, "preview");
        ConfigurationHandler.runValidators(Configuration.TooltipCategory.class, config.tooltip, "tooltip");
        ConfigurationHandler.runValidators(Configuration.ServerCategory.class, config.server, "server");
        if (ShulkerBoxTooltip.isClient()) {
            if (config.controls.previewKey == null) {
                config.controls.previewKey = Key.defaultPreviewKey();
            }
            if (config.controls.fullPreviewKey == null) {
                config.controls.fullPreviewKey = Key.defaultFullPreviewKey();
            }
            ConfigurationHandler.runValidators(Configuration.ControlsCategory.class, config.controls, "controls");
        }
    }

    private static <T> void runValidators(Class<T> categoryClass, T category, String categoryName) throws ConfigData.ValidationException {
        try {
            for (Field field : categoryClass.getDeclaredFields()) {
                Validator validator = field.getAnnotation(Validator.class);
                if (validator == null) continue;
                field.setAccessible(true);
                Optional<class_2561> errorMsg = ConfigurationHandler.getValidatorFunction(validator).apply(field.get(category));
                if (!errorMsg.isPresent()) continue;
                throw new ConfigData.ValidationException("ShulkerBoxTooltip config field " + categoryName + "." + field.getName() + " is invalid: " + class_2477.method_10517().method_4679(errorMsg.get().getString()));
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ConfigData.ValidationException((Throwable)e);
        }
    }

    private static Function<Object, Optional<class_2561>> getValidatorFunction(Validator validator) {
        try {
            Constructor<? extends Function<Object, Optional<class_2561>>> constructor = validator.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't create config validator", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void reinitClientSideSyncedValues(Configuration config) {
        config.server.clientIntegration = false;
        config.server.enderChestSyncType = Configuration.EnderChestSyncType.NONE;
    }

    public static void onSave() {
        if (ShulkerBoxTooltip.savedConfig == null) {
            return;
        }
        Configuration.ServerCategory serverCategory = ShulkerBoxTooltip.config == null ? new Configuration.ServerCategory() : ShulkerBoxTooltip.config.server;
        ShulkerBoxTooltip.config = ConfigurationHandler.copyOf(ShulkerBoxTooltip.savedConfig);
        ShulkerBoxTooltip.config.server = serverCategory;
    }

    public static void readFromPacketBuf(Configuration config, class_2540 buf) {
        class_2487 compound = buf.method_10798();
        if (compound != null && compound.method_10573("server", 10)) {
            class_2487 serverTag = compound.method_10562("server");
            if (serverTag.method_10573("clientIntegration", 1)) {
                config.server.clientIntegration = serverTag.method_10577("clientIntegration");
            }
            if (serverTag.method_10573("enderChestSyncType", 8)) {
                config.server.enderChestSyncType = ConfigurationHandler.getEnumFromName(Configuration.EnderChestSyncType.class, Configuration.EnderChestSyncType.NONE, serverTag.method_10558("enderChestSyncType"));
            }
        }
    }

    public static void writeToPacketBuf(Configuration config, class_2540 buf) {
        class_2487 compound = new class_2487();
        class_2487 serverTag = new class_2487();
        serverTag.method_10556("clientIntegration", config.server.clientIntegration);
        serverTag.method_10582("enderChestSyncType", config.server.enderChestSyncType.name());
        compound.method_10566("server", (class_2520)serverTag);
        buf.method_10794(compound);
    }

    private static <E extends Enum<E>> E getEnumFromName(Class<E> clazz, E defaultValue, String name) {
        if (clazz != null && name != null) {
            try {
                E e = Enum.valueOf(clazz, name);
                return e == null ? defaultValue : e;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

