/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.renderer.BasePreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class ModPreviewRenderer
extends BasePreviewRenderer {
    private static final class_2960 DEFAULT_TEXTURE_LIGHT = new class_2960("shulkerboxtooltip", "textures/gui/shulker_box_tooltip.png");
    private static final class_2960 DEFAULT_TEXTURE_DARK = new class_2960("shulkerboxtooltip", "textures/gui/shulker_box_tooltip_dark.png");
    public static final ModPreviewRenderer INSTANCE = new ModPreviewRenderer();

    ModPreviewRenderer() {
        super(18, 18, 8, 8);
    }

    @Override
    public int getWidth() {
        return 14 + Math.min(this.getMaxRowSize(), this.getInvSize()) * 18;
    }

    @Override
    public int getHeight() {
        return 14 + (int)Math.ceil((double)this.getInvSize() / (double)this.getMaxRowSize()) * 18;
    }

    private float[] setColor() {
        float[] color;
        if (ShulkerBoxTooltip.config.preview.coloredPreview) {
            color = this.provider.getWindowColor(this.previewContext);
            if (color == null || color.length < 3) {
                color = PreviewProvider.DEFAULT_COLOR;
            }
        } else {
            color = PreviewProvider.DEFAULT_COLOR;
        }
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        return color;
    }

    private void setTexture(float[] color) {
        class_2960 texture = this.textureOverride;
        if (texture == null) {
            Configuration.Theme theme = ShulkerBoxTooltip.config.preview.theme;
            texture = theme == Configuration.Theme.MOD_DARK && (Arrays.equals(color, PreviewProvider.DEFAULT_COLOR) || Arrays.equals(color, class_1767.field_7952.method_7787())) ? DEFAULT_TEXTURE_DARK : DEFAULT_TEXTURE_LIGHT;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    private void drawBackground(int x, int y, int z, class_4587 matrices) {
        int s;
        int size;
        int zOffset = z + 100;
        int invSize = this.getInvSize();
        int xOffset = 7;
        int yOffset = 7;
        int rowTexYPos = 7;
        int rowSize = Math.min(this.getMaxRowSize(), invSize);
        int rowWidth = rowSize * 18;
        this.setTexture(this.setColor());
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            class_332.method_25291((class_4587)matrices, (int)(x + xOffset), (int)y, (int)zOffset, (float)7.0f, (float)0.0f, (int)(s * 18), (int)7, (int)256, (int)256);
            xOffset += s * 18;
        }
        while (invSize > 0) {
            xOffset = 7;
            class_332.method_25291((class_4587)matrices, (int)x, (int)(y + yOffset), (int)zOffset, (float)0.0f, (float)rowTexYPos, (int)7, (int)18, (int)256, (int)256);
            for (int rSize = rowSize; rSize > 0; rSize -= 9) {
                s = Math.min(rSize, 9);
                class_332.method_25291((class_4587)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)7.0f, (float)rowTexYPos, (int)(s * 18), (int)18, (int)256, (int)256);
                xOffset += s * 18;
            }
            class_332.method_25291((class_4587)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)169.0f, (float)rowTexYPos, (int)7, (int)18, (int)256, (int)256);
            yOffset += 18;
            invSize -= rowSize;
            rowTexYPos = rowTexYPos >= 43 ? 7 : rowTexYPos + 18;
        }
        xOffset = 7;
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            class_332.method_25291((class_4587)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)7.0f, (float)61.0f, (int)(s * 18), (int)7, (int)256, (int)256);
            xOffset += s * 18;
        }
        class_332.method_25291((class_4587)matrices, (int)x, (int)y, (int)zOffset, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(x + rowWidth + 7), (int)y, (int)zOffset, (float)169.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(x + rowWidth + 7), (int)(y + yOffset), (int)zOffset, (float)169.0f, (float)61.0f, (int)7, (int)7, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)x, (int)(y + yOffset), (int)zOffset, (float)0.0f, (float)61.0f, (int)7, (int)7, (int)256, (int)256);
    }

    @Override
    public void draw(int x, int y, int z, class_4587 matrices, class_327 textRenderer, class_918 itemRenderer, class_1060 textureManager) {
        if (this.items.isEmpty() || this.previewType == PreviewType.NO_PREVIEW) {
            return;
        }
        RenderSystem.enableDepthTest();
        this.drawBackground(x, y, z, matrices);
        this.drawItems(x, y, z, textRenderer, itemRenderer);
    }
}

