/*
 * Decompiled with CFR 0.152.
 */
package tk.blitzfarm.anticheat.velocity;

import com.google.common.io.ByteArrayDataInput;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;
import tk.blitzfarm.anticheat.velocity.command.AnticheatCommand;
import tk.blitzfarm.anticheat.velocity.floodgate.FloodgateApiHolder;

@Plugin(id="anticheat", name="Anticheat", version="1.0.0", authors={"XXMA16"}, dependencies={@Dependency(id="floodgate", optional=true)})
public final class ServerAC {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Path dataDirectory;
    private final FloodgateApiHolder floodgateApi;
    private final Set<String> legitPlayers = new HashSet<String>();
    private static final ChannelIdentifier ANTICHEAT_CHANNEL = MinecraftChannelIdentifier.create((String)"fabric", (String)"anticheat");
    private static final Set<String> hashes = new HashSet<String>();
    private boolean enabled = true;

    @Inject
    public ServerAC(Logger logger, ProxyServer proxy, @DataDirectory Path dataDirectory) {
        this.logger = logger;
        this.proxy = proxy;
        this.dataDirectory = dataDirectory;
        this.floodgateApi = this.proxy.getPluginManager().getPlugin("floodgate").isPresent() ? new FloodgateApiHolder() : null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.proxy.getChannelRegistrar().register(new ChannelIdentifier[]{ANTICHEAT_CHANNEL});
        this.refreshHashes();
        AnticheatCommand.register(this);
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().equals(ANTICHEAT_CHANNEL)) {
            return;
        }
        ByteArrayDataInput input = event.dataAsDataStream();
        boolean codat = false;
        int lines = input.readInt();
        for (int i = 0; i < lines; ++i) {
            String hash = input.readUTF();
            if (hashes.contains(hash)) continue;
            codat = true;
            break;
        }
        if (!codat) {
            this.legitPlayers.add(((Player)event.getSource()).getUsername());
        }
    }

    @Subscribe
    public void onSMPPreJoin(ServerPreConnectEvent event) {
        if (!event.getOriginalServer().getServerInfo().getName().equals("SMP") || !this.enabled) {
            return;
        }
        if (this.floodgateApi != null && this.floodgateApi.isFloodgatePlayer(event.getPlayer().getUniqueId())) {
            return;
        }
        if (!this.legitPlayers.contains(event.getPlayer().getUsername())) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
            event.getPlayer().sendMessage((Component)Component.text((String)"Please install the anticheat mod on your client and make sure you only have allowed mods enabled", (TextColor)NamedTextColor.RED));
        }
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        this.legitPlayers.remove(event.getPlayer().getUsername());
    }

    public void refreshHashes() {
        hashes.clear();
        ((CompletableFuture)((CompletableFuture)HttpClient.newHttpClient().sendAsync(HttpRequest.newBuilder().uri(URI.create("https://www.blitzfarm.tk/allowed-mods.txt")).build(), HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(string -> hashes.addAll(Arrays.stream(string.split("\n")).map(s -> s.substring(0, 32)).toList()))).join();
    }
}

