/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.macos.jna.avfoundation;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVFoundation;
import de.maxhenkel.voicechat.macos.jna.foundation.NSObject;
import de.maxhenkel.voicechat.macos.jna.foundation.NSString;

public class AVCaptureDevice
extends NSObject {
    private static final Pointer nativeClass = AVFoundation.INSTANCE.objc_getClass("AVCaptureDevice");
    private static final Pointer authorizationStatusForMediaTypeSelector = AVFoundation.INSTANCE.sel_registerName("authorizationStatusForMediaType:");
    private static final Pointer requestAccessForMediaTypeSelector = AVFoundation.INSTANCE.sel_registerName("requestAccessForMediaType:completionHandler:");

    public AVCaptureDevice() {
        super(new NativeLong(-1L));
    }

    public static AVAuthorizationStatus getAuthorizationStatus(NSString mediaType) {
        NativeLong permissionEnum = AVFoundation.INSTANCE.objc_msgSend(nativeClass, authorizationStatusForMediaTypeSelector, mediaType.getId());
        return AVAuthorizationStatus.byValue(permissionEnum);
    }

    public static void requestAccessForMediaType(NSString mediaType) {
        AVFoundation.INSTANCE.objc_msgSend(nativeClass, requestAccessForMediaTypeSelector, mediaType.getId(), null);
    }
}

